// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Kubernetes storage class info. </summary>
    public partial class EdgeKubernetesRoleStorageClassInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdgeKubernetesRoleStorageClassInfo"/>. </summary>
        internal EdgeKubernetesRoleStorageClassInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EdgeKubernetesRoleStorageClassInfo"/>. </summary>
        /// <param name="name"> Storage class name. </param>
        /// <param name="kubernetesRoleStorageClassInfoType"> Storage class type. </param>
        /// <param name="posixCompliant"> If provisioned storage is posix compliant. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdgeKubernetesRoleStorageClassInfo(string name, string kubernetesRoleStorageClassInfoType, PosixComplianceStatus? posixCompliant, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            KubernetesRoleStorageClassInfoType = kubernetesRoleStorageClassInfoType;
            PosixCompliant = posixCompliant;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Storage class name. </summary>
        public string Name { get; }
        /// <summary> Storage class type. </summary>
        public string KubernetesRoleStorageClassInfoType { get; }
        /// <summary> If provisioned storage is posix compliant. </summary>
        public PosixComplianceStatus? PosixCompliant { get; }
    }
}
