// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Node type - Master/Worker. </summary>
    public readonly partial struct EdgeKubernetesNodeType : IEquatable<EdgeKubernetesNodeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EdgeKubernetesNodeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EdgeKubernetesNodeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string MasterValue = "Master";
        private const string WorkerValue = "Worker";

        /// <summary> Invalid. </summary>
        public static EdgeKubernetesNodeType Invalid { get; } = new EdgeKubernetesNodeType(InvalidValue);
        /// <summary> Master. </summary>
        public static EdgeKubernetesNodeType Master { get; } = new EdgeKubernetesNodeType(MasterValue);
        /// <summary> Worker. </summary>
        public static EdgeKubernetesNodeType Worker { get; } = new EdgeKubernetesNodeType(WorkerValue);
        /// <summary> Determines if two <see cref="EdgeKubernetesNodeType"/> values are the same. </summary>
        public static bool operator ==(EdgeKubernetesNodeType left, EdgeKubernetesNodeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EdgeKubernetesNodeType"/> values are not the same. </summary>
        public static bool operator !=(EdgeKubernetesNodeType left, EdgeKubernetesNodeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EdgeKubernetesNodeType"/>. </summary>
        public static implicit operator EdgeKubernetesNodeType(string value) => new EdgeKubernetesNodeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EdgeKubernetesNodeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EdgeKubernetesNodeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
