// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Kubernetes node info. </summary>
    public partial class EdgeKubernetesNodeInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdgeKubernetesNodeInfo"/>. </summary>
        internal EdgeKubernetesNodeInfo()
        {
            IPConfiguration = new ChangeTrackingList<EdgeKubernetesIPConfiguration>();
        }

        /// <summary> Initializes a new instance of <see cref="EdgeKubernetesNodeInfo"/>. </summary>
        /// <param name="name"> Node name. </param>
        /// <param name="nodeType"> Node type - Master/Worker. </param>
        /// <param name="ipConfiguration"> IP Configuration of the Kubernetes node. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdgeKubernetesNodeInfo(string name, EdgeKubernetesNodeType? nodeType, IReadOnlyList<EdgeKubernetesIPConfiguration> ipConfiguration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            NodeType = nodeType;
            IPConfiguration = ipConfiguration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Node name. </summary>
        public string Name { get; }
        /// <summary> Node type - Master/Worker. </summary>
        public EdgeKubernetesNodeType? NodeType { get; }
        /// <summary> IP Configuration of the Kubernetes node. </summary>
        public IReadOnlyList<EdgeKubernetesIPConfiguration> IPConfiguration { get; }
    }
}
