// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> For changing or to initiate the resync to key-vault set the status to KeyVaultSyncPending, rest of the status will not be applicable. </summary>
    public readonly partial struct EdgeKeyVaultSyncStatus : IEquatable<EdgeKeyVaultSyncStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EdgeKeyVaultSyncStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EdgeKeyVaultSyncStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string KeyVaultSyncedValue = "KeyVaultSynced";
        private const string KeyVaultSyncFailedValue = "KeyVaultSyncFailed";
        private const string KeyVaultNotConfiguredValue = "KeyVaultNotConfigured";
        private const string KeyVaultSyncPendingValue = "KeyVaultSyncPending";
        private const string KeyVaultSyncingValue = "KeyVaultSyncing";
        private const string KeyVaultNotSyncedValue = "KeyVaultNotSynced";

        /// <summary> KeyVaultSynced. </summary>
        public static EdgeKeyVaultSyncStatus KeyVaultSynced { get; } = new EdgeKeyVaultSyncStatus(KeyVaultSyncedValue);
        /// <summary> KeyVaultSyncFailed. </summary>
        public static EdgeKeyVaultSyncStatus KeyVaultSyncFailed { get; } = new EdgeKeyVaultSyncStatus(KeyVaultSyncFailedValue);
        /// <summary> KeyVaultNotConfigured. </summary>
        public static EdgeKeyVaultSyncStatus KeyVaultNotConfigured { get; } = new EdgeKeyVaultSyncStatus(KeyVaultNotConfiguredValue);
        /// <summary> KeyVaultSyncPending. </summary>
        public static EdgeKeyVaultSyncStatus KeyVaultSyncPending { get; } = new EdgeKeyVaultSyncStatus(KeyVaultSyncPendingValue);
        /// <summary> KeyVaultSyncing. </summary>
        public static EdgeKeyVaultSyncStatus KeyVaultSyncing { get; } = new EdgeKeyVaultSyncStatus(KeyVaultSyncingValue);
        /// <summary> KeyVaultNotSynced. </summary>
        public static EdgeKeyVaultSyncStatus KeyVaultNotSynced { get; } = new EdgeKeyVaultSyncStatus(KeyVaultNotSyncedValue);
        /// <summary> Determines if two <see cref="EdgeKeyVaultSyncStatus"/> values are the same. </summary>
        public static bool operator ==(EdgeKeyVaultSyncStatus left, EdgeKeyVaultSyncStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EdgeKeyVaultSyncStatus"/> values are not the same. </summary>
        public static bool operator !=(EdgeKeyVaultSyncStatus left, EdgeKeyVaultSyncStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EdgeKeyVaultSyncStatus"/>. </summary>
        public static implicit operator EdgeKeyVaultSyncStatus(string value) => new EdgeKeyVaultSyncStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EdgeKeyVaultSyncStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EdgeKeyVaultSyncStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
