// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Cluster Witness Type. </summary>
    public readonly partial struct EdgeClusterWitnessType : IEquatable<EdgeClusterWitnessType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EdgeClusterWitnessType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EdgeClusterWitnessType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string CloudValue = "Cloud";
        private const string FileShareValue = "FileShare";

        /// <summary> None. </summary>
        public static EdgeClusterWitnessType None { get; } = new EdgeClusterWitnessType(NoneValue);
        /// <summary> Cloud. </summary>
        public static EdgeClusterWitnessType Cloud { get; } = new EdgeClusterWitnessType(CloudValue);
        /// <summary> FileShare. </summary>
        public static EdgeClusterWitnessType FileShare { get; } = new EdgeClusterWitnessType(FileShareValue);
        /// <summary> Determines if two <see cref="EdgeClusterWitnessType"/> values are the same. </summary>
        public static bool operator ==(EdgeClusterWitnessType left, EdgeClusterWitnessType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EdgeClusterWitnessType"/> values are not the same. </summary>
        public static bool operator !=(EdgeClusterWitnessType left, EdgeClusterWitnessType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EdgeClusterWitnessType"/>. </summary>
        public static implicit operator EdgeClusterWitnessType(string value) => new EdgeClusterWitnessType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EdgeClusterWitnessType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EdgeClusterWitnessType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
