// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Cluster GPU Data. </summary>
    public partial class EdgeClusterGpuCapacity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdgeClusterGpuCapacity"/>. </summary>
        public EdgeClusterGpuCapacity()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EdgeClusterGpuCapacity"/>. </summary>
        /// <param name="gpuType"> The cluster GPU Type. </param>
        /// <param name="gpuUsedUnitsCount"> The used GPU units count in the cluster. </param>
        /// <param name="gpuFreeUnitsCount"> The free GPU units count in the cluster. </param>
        /// <param name="gpuReservedForFailoverUnitsCount"> The GPU units count reserved for failover in the cluster. </param>
        /// <param name="gpuTotalUnitsCount"> The total GPU units count in the cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdgeClusterGpuCapacity(string gpuType, int? gpuUsedUnitsCount, int? gpuFreeUnitsCount, int? gpuReservedForFailoverUnitsCount, int? gpuTotalUnitsCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            GpuType = gpuType;
            GpuUsedUnitsCount = gpuUsedUnitsCount;
            GpuFreeUnitsCount = gpuFreeUnitsCount;
            GpuReservedForFailoverUnitsCount = gpuReservedForFailoverUnitsCount;
            GpuTotalUnitsCount = gpuTotalUnitsCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The cluster GPU Type. </summary>
        public string GpuType { get; set; }
        /// <summary> The used GPU units count in the cluster. </summary>
        public int? GpuUsedUnitsCount { get; set; }
        /// <summary> The free GPU units count in the cluster. </summary>
        public int? GpuFreeUnitsCount { get; set; }
        /// <summary> The GPU units count reserved for failover in the cluster. </summary>
        public int? GpuReservedForFailoverUnitsCount { get; set; }
        /// <summary> The total GPU units count in the cluster. </summary>
        public int? GpuTotalUnitsCount { get; set; }
    }
}
