// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    public partial class EdgeClusterGpuCapacity : IUtf8JsonSerializable, IJsonModel<EdgeClusterGpuCapacity>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<EdgeClusterGpuCapacity>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<EdgeClusterGpuCapacity>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdgeClusterGpuCapacity>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EdgeClusterGpuCapacity)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(GpuType))
            {
                writer.WritePropertyName("gpuType"u8);
                writer.WriteStringValue(GpuType);
            }
            if (Optional.IsDefined(GpuUsedUnitsCount))
            {
                writer.WritePropertyName("gpuUsedUnitsCount"u8);
                writer.WriteNumberValue(GpuUsedUnitsCount.Value);
            }
            if (Optional.IsDefined(GpuFreeUnitsCount))
            {
                writer.WritePropertyName("gpuFreeUnitsCount"u8);
                writer.WriteNumberValue(GpuFreeUnitsCount.Value);
            }
            if (Optional.IsDefined(GpuReservedForFailoverUnitsCount))
            {
                writer.WritePropertyName("gpuReservedForFailoverUnitsCount"u8);
                writer.WriteNumberValue(GpuReservedForFailoverUnitsCount.Value);
            }
            if (Optional.IsDefined(GpuTotalUnitsCount))
            {
                writer.WritePropertyName("gpuTotalUnitsCount"u8);
                writer.WriteNumberValue(GpuTotalUnitsCount.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        EdgeClusterGpuCapacity IJsonModel<EdgeClusterGpuCapacity>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdgeClusterGpuCapacity>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EdgeClusterGpuCapacity)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeEdgeClusterGpuCapacity(document.RootElement, options);
        }

        internal static EdgeClusterGpuCapacity DeserializeEdgeClusterGpuCapacity(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string gpuType = default;
            int? gpuUsedUnitsCount = default;
            int? gpuFreeUnitsCount = default;
            int? gpuReservedForFailoverUnitsCount = default;
            int? gpuTotalUnitsCount = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("gpuType"u8))
                {
                    gpuType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("gpuUsedUnitsCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    gpuUsedUnitsCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("gpuFreeUnitsCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    gpuFreeUnitsCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("gpuReservedForFailoverUnitsCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    gpuReservedForFailoverUnitsCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("gpuTotalUnitsCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    gpuTotalUnitsCount = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new EdgeClusterGpuCapacity(
                gpuType,
                gpuUsedUnitsCount,
                gpuFreeUnitsCount,
                gpuReservedForFailoverUnitsCount,
                gpuTotalUnitsCount,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<EdgeClusterGpuCapacity>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdgeClusterGpuCapacity>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(EdgeClusterGpuCapacity)} does not support writing '{options.Format}' format.");
            }
        }

        EdgeClusterGpuCapacity IPersistableModel<EdgeClusterGpuCapacity>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdgeClusterGpuCapacity>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeEdgeClusterGpuCapacity(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(EdgeClusterGpuCapacity)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<EdgeClusterGpuCapacity>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
