// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Cluster Compute Data. </summary>
    public partial class EdgeClusterCapacityViewInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdgeClusterCapacityViewInfo"/>. </summary>
        public EdgeClusterCapacityViewInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EdgeClusterCapacityViewInfo"/>. </summary>
        /// <param name="fqdn"> The FQDN of the cluster. </param>
        /// <param name="gpuCapacity"> The cluster's GPU capacity. </param>
        /// <param name="memoryCapacity"> The cluster's memory capacity. </param>
        /// <param name="lastRefreshedOn"> The last time at which the ClusterCapacityViewData was set. </param>
        /// <param name="totalProvisionedNonHpnCores"> The total # of vCPUs provisioned by non-HPN VM per appliance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdgeClusterCapacityViewInfo(string fqdn, EdgeClusterGpuCapacity gpuCapacity, EdgeClusterMemoryCapacity memoryCapacity, DateTimeOffset? lastRefreshedOn, long? totalProvisionedNonHpnCores, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Fqdn = fqdn;
            GpuCapacity = gpuCapacity;
            MemoryCapacity = memoryCapacity;
            LastRefreshedOn = lastRefreshedOn;
            TotalProvisionedNonHpnCores = totalProvisionedNonHpnCores;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The FQDN of the cluster. </summary>
        public string Fqdn { get; set; }
        /// <summary> The cluster's GPU capacity. </summary>
        public EdgeClusterGpuCapacity GpuCapacity { get; set; }
        /// <summary> The cluster's memory capacity. </summary>
        public EdgeClusterMemoryCapacity MemoryCapacity { get; set; }
        /// <summary> The last time at which the ClusterCapacityViewData was set. </summary>
        public DateTimeOffset? LastRefreshedOn { get; set; }
        /// <summary> The total # of vCPUs provisioned by non-HPN VM per appliance. </summary>
        public long? TotalProvisionedNonHpnCores { get; set; }
    }
}
