// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Type of access to be allowed for the client. </summary>
    public readonly partial struct EdgeClientPermissionType : IEquatable<EdgeClientPermissionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EdgeClientPermissionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EdgeClientPermissionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoAccessValue = "NoAccess";
        private const string ReadOnlyValue = "ReadOnly";
        private const string ReadWriteValue = "ReadWrite";

        /// <summary> NoAccess. </summary>
        public static EdgeClientPermissionType NoAccess { get; } = new EdgeClientPermissionType(NoAccessValue);
        /// <summary> ReadOnly. </summary>
        public static EdgeClientPermissionType ReadOnly { get; } = new EdgeClientPermissionType(ReadOnlyValue);
        /// <summary> ReadWrite. </summary>
        public static EdgeClientPermissionType ReadWrite { get; } = new EdgeClientPermissionType(ReadWriteValue);
        /// <summary> Determines if two <see cref="EdgeClientPermissionType"/> values are the same. </summary>
        public static bool operator ==(EdgeClientPermissionType left, EdgeClientPermissionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EdgeClientPermissionType"/> values are not the same. </summary>
        public static bool operator !=(EdgeClientPermissionType left, EdgeClientPermissionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EdgeClientPermissionType"/>. </summary>
        public static implicit operator EdgeClientPermissionType(string value) => new EdgeClientPermissionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EdgeClientPermissionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EdgeClientPermissionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
