// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Object for Capturing DeviceCapacityRequestInfo. </summary>
    public partial class DeviceCapacityRequestContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeviceCapacityRequestContent"/>. </summary>
        /// <param name="vmPlacementQuery"> Array containing the sizes of the VMs for checking if its feasible to create them on the appliance. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="vmPlacementQuery"/> is null. </exception>
        public DeviceCapacityRequestContent(IEnumerable<IList<string>> vmPlacementQuery)
        {
            Argument.AssertNotNull(vmPlacementQuery, nameof(vmPlacementQuery));

            VmPlacementQuery = vmPlacementQuery.ToList();
            VmPlacementResults = new ChangeTrackingList<VmPlacementRequestResult>();
        }

        /// <summary> Initializes a new instance of <see cref="DeviceCapacityRequestContent"/>. </summary>
        /// <param name="vmPlacementQuery"> Array containing the sizes of the VMs for checking if its feasible to create them on the appliance. </param>
        /// <param name="vmPlacementResults"> Array of the VMs of the sizes in VmSizes can be provisioned on the appliance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeviceCapacityRequestContent(IList<IList<string>> vmPlacementQuery, IList<VmPlacementRequestResult> vmPlacementResults, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VmPlacementQuery = vmPlacementQuery;
            VmPlacementResults = vmPlacementResults;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DeviceCapacityRequestContent"/> for deserialization. </summary>
        internal DeviceCapacityRequestContent()
        {
        }

        /// <summary> Array containing the sizes of the VMs for checking if its feasible to create them on the appliance. </summary>
        public IList<IList<string>> VmPlacementQuery { get; }
        /// <summary> Array of the VMs of the sizes in VmSizes can be provisioned on the appliance. </summary>
        public IList<VmPlacementRequestResult> VmPlacementResults { get; }
    }
}
