// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> VmMemory Data. </summary>
    public partial class DataBoxEdgeVmMemory
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeVmMemory"/>. </summary>
        public DataBoxEdgeVmMemory()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeVmMemory"/>. </summary>
        /// <param name="startupMemoryInMB"> The total amount of RAM in the virtual machine, as seen by the guest  operating system. For a virtual machine with dynamic memory enabled, this represents the initial memory available at startup. </param>
        /// <param name="currentMemoryUsageInMB"> The current memory used by the virtual machine. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxEdgeVmMemory(long? startupMemoryInMB, long? currentMemoryUsageInMB, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StartupMemoryInMB = startupMemoryInMB;
            CurrentMemoryUsageInMB = currentMemoryUsageInMB;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The total amount of RAM in the virtual machine, as seen by the guest  operating system. For a virtual machine with dynamic memory enabled, this represents the initial memory available at startup. </summary>
        public long? StartupMemoryInMB { get; set; }
        /// <summary> The current memory used by the virtual machine. </summary>
        public long? CurrentMemoryUsageInMB { get; set; }
    }
}
