// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Type of the user. </summary>
    public readonly partial struct DataBoxEdgeUserType : IEquatable<DataBoxEdgeUserType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeUserType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeUserType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ShareValue = "Share";
        private const string LocalManagementValue = "LocalManagement";
        private const string ArmValue = "ARM";

        /// <summary> Share. </summary>
        public static DataBoxEdgeUserType Share { get; } = new DataBoxEdgeUserType(ShareValue);
        /// <summary> LocalManagement. </summary>
        public static DataBoxEdgeUserType LocalManagement { get; } = new DataBoxEdgeUserType(LocalManagementValue);
        /// <summary> ARM. </summary>
        public static DataBoxEdgeUserType Arm { get; } = new DataBoxEdgeUserType(ArmValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeUserType"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeUserType left, DataBoxEdgeUserType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeUserType"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeUserType left, DataBoxEdgeUserType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeUserType"/>. </summary>
        public static implicit operator DataBoxEdgeUserType(string value) => new DataBoxEdgeUserType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeUserType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeUserType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
