// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Status of the update. </summary>
    public readonly partial struct DataBoxEdgeUpdateStatus : IEquatable<DataBoxEdgeUpdateStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeUpdateStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeUpdateStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DownloadPendingValue = "DownloadPending";
        private const string DownloadStartedValue = "DownloadStarted";
        private const string DownloadCompletedValue = "DownloadCompleted";
        private const string InstallStartedValue = "InstallStarted";
        private const string InstallCompletedValue = "InstallCompleted";

        /// <summary> DownloadPending. </summary>
        public static DataBoxEdgeUpdateStatus DownloadPending { get; } = new DataBoxEdgeUpdateStatus(DownloadPendingValue);
        /// <summary> DownloadStarted. </summary>
        public static DataBoxEdgeUpdateStatus DownloadStarted { get; } = new DataBoxEdgeUpdateStatus(DownloadStartedValue);
        /// <summary> DownloadCompleted. </summary>
        public static DataBoxEdgeUpdateStatus DownloadCompleted { get; } = new DataBoxEdgeUpdateStatus(DownloadCompletedValue);
        /// <summary> InstallStarted. </summary>
        public static DataBoxEdgeUpdateStatus InstallStarted { get; } = new DataBoxEdgeUpdateStatus(InstallStartedValue);
        /// <summary> InstallCompleted. </summary>
        public static DataBoxEdgeUpdateStatus InstallCompleted { get; } = new DataBoxEdgeUpdateStatus(InstallCompletedValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeUpdateStatus"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeUpdateStatus left, DataBoxEdgeUpdateStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeUpdateStatus"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeUpdateStatus left, DataBoxEdgeUpdateStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeUpdateStatus"/>. </summary>
        public static implicit operator DataBoxEdgeUpdateStatus(string value) => new DataBoxEdgeUpdateStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeUpdateStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeUpdateStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
