// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The current update operation. </summary>
    public readonly partial struct DataBoxEdgeUpdateOperation : IEquatable<DataBoxEdgeUpdateOperation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeUpdateOperation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeUpdateOperation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ScanValue = "Scan";
        private const string DownloadValue = "Download";
        private const string InstallValue = "Install";

        /// <summary> None. </summary>
        public static DataBoxEdgeUpdateOperation None { get; } = new DataBoxEdgeUpdateOperation(NoneValue);
        /// <summary> Scan. </summary>
        public static DataBoxEdgeUpdateOperation Scan { get; } = new DataBoxEdgeUpdateOperation(ScanValue);
        /// <summary> Download. </summary>
        public static DataBoxEdgeUpdateOperation Download { get; } = new DataBoxEdgeUpdateOperation(DownloadValue);
        /// <summary> Install. </summary>
        public static DataBoxEdgeUpdateOperation Install { get; } = new DataBoxEdgeUpdateOperation(InstallValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeUpdateOperation"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeUpdateOperation left, DataBoxEdgeUpdateOperation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeUpdateOperation"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeUpdateOperation left, DataBoxEdgeUpdateOperation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeUpdateOperation"/>. </summary>
        public static implicit operator DataBoxEdgeUpdateOperation(string value) => new DataBoxEdgeUpdateOperation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeUpdateOperation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeUpdateOperation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
