// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Update Specific attributes. </summary>
    public partial class DataBoxEdgeUpdateDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeUpdateDetails"/>. </summary>
        internal DataBoxEdgeUpdateDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeUpdateDetails"/>. </summary>
        /// <param name="updateTitle"> Title of the Update. </param>
        /// <param name="updateSizeInBytes"> Size of the update(In Bytes). </param>
        /// <param name="updateType"> Type of the Update. </param>
        /// <param name="targetVersion"> Target Version number. </param>
        /// <param name="friendlyVersionNumber"> Friendly Version Number. </param>
        /// <param name="estimatedInstallTimeInMins"> Estimated Install Time for the update. </param>
        /// <param name="rebootBehavior"> Indicates if updates are available and at least one of the updates needs a reboot. </param>
        /// <param name="installationImpact"> Impact of Installing an updateType. </param>
        /// <param name="status"> Status of the update. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxEdgeUpdateDetails(string updateTitle, double? updateSizeInBytes, DataBoxEdgeUpdateType? updateType, string targetVersion, string friendlyVersionNumber, int? estimatedInstallTimeInMins, InstallRebootBehavior? rebootBehavior, InstallationImpact? installationImpact, DataBoxEdgeUpdateStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UpdateTitle = updateTitle;
            UpdateSizeInBytes = updateSizeInBytes;
            UpdateType = updateType;
            TargetVersion = targetVersion;
            FriendlyVersionNumber = friendlyVersionNumber;
            EstimatedInstallTimeInMins = estimatedInstallTimeInMins;
            RebootBehavior = rebootBehavior;
            InstallationImpact = installationImpact;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Title of the Update. </summary>
        public string UpdateTitle { get; }
        /// <summary> Size of the update(In Bytes). </summary>
        public double? UpdateSizeInBytes { get; }
        /// <summary> Type of the Update. </summary>
        public DataBoxEdgeUpdateType? UpdateType { get; }
        /// <summary> Target Version number. </summary>
        public string TargetVersion { get; }
        /// <summary> Friendly Version Number. </summary>
        public string FriendlyVersionNumber { get; }
        /// <summary> Estimated Install Time for the update. </summary>
        public int? EstimatedInstallTimeInMins { get; }
        /// <summary> Indicates if updates are available and at least one of the updates needs a reboot. </summary>
        public InstallRebootBehavior? RebootBehavior { get; }
        /// <summary> Impact of Installing an updateType. </summary>
        public InstallationImpact? InstallationImpact { get; }
        /// <summary> Status of the update. </summary>
        public DataBoxEdgeUpdateStatus? Status { get; }
    }
}
