// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The DataBoxEdgeSubscriptionState. </summary>
    public readonly partial struct DataBoxEdgeSubscriptionState : IEquatable<DataBoxEdgeSubscriptionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeSubscriptionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeSubscriptionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RegisteredValue = "Registered";
        private const string WarnedValue = "Warned";
        private const string SuspendedValue = "Suspended";
        private const string DeletedValue = "Deleted";
        private const string UnregisteredValue = "Unregistered";

        /// <summary> Registered. </summary>
        public static DataBoxEdgeSubscriptionState Registered { get; } = new DataBoxEdgeSubscriptionState(RegisteredValue);
        /// <summary> Warned. </summary>
        public static DataBoxEdgeSubscriptionState Warned { get; } = new DataBoxEdgeSubscriptionState(WarnedValue);
        /// <summary> Suspended. </summary>
        public static DataBoxEdgeSubscriptionState Suspended { get; } = new DataBoxEdgeSubscriptionState(SuspendedValue);
        /// <summary> Deleted. </summary>
        public static DataBoxEdgeSubscriptionState Deleted { get; } = new DataBoxEdgeSubscriptionState(DeletedValue);
        /// <summary> Unregistered. </summary>
        public static DataBoxEdgeSubscriptionState Unregistered { get; } = new DataBoxEdgeSubscriptionState(UnregisteredValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeSubscriptionState"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeSubscriptionState left, DataBoxEdgeSubscriptionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeSubscriptionState"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeSubscriptionState left, DataBoxEdgeSubscriptionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeSubscriptionState"/>. </summary>
        public static implicit operator DataBoxEdgeSubscriptionState(string value) => new DataBoxEdgeSubscriptionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeSubscriptionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeSubscriptionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
