// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Current status of the container. </summary>
    public readonly partial struct DataBoxEdgeStorageContainerStatus : IEquatable<DataBoxEdgeStorageContainerStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeStorageContainerStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeStorageContainerStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OKValue = "OK";
        private const string OfflineValue = "Offline";
        private const string UnknownValue = "Unknown";
        private const string UpdatingValue = "Updating";
        private const string NeedsAttentionValue = "NeedsAttention";

        /// <summary> OK. </summary>
        public static DataBoxEdgeStorageContainerStatus OK { get; } = new DataBoxEdgeStorageContainerStatus(OKValue);
        /// <summary> Offline. </summary>
        public static DataBoxEdgeStorageContainerStatus Offline { get; } = new DataBoxEdgeStorageContainerStatus(OfflineValue);
        /// <summary> Unknown. </summary>
        public static DataBoxEdgeStorageContainerStatus Unknown { get; } = new DataBoxEdgeStorageContainerStatus(UnknownValue);
        /// <summary> Updating. </summary>
        public static DataBoxEdgeStorageContainerStatus Updating { get; } = new DataBoxEdgeStorageContainerStatus(UpdatingValue);
        /// <summary> NeedsAttention. </summary>
        public static DataBoxEdgeStorageContainerStatus NeedsAttention { get; } = new DataBoxEdgeStorageContainerStatus(NeedsAttentionValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeStorageContainerStatus"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeStorageContainerStatus left, DataBoxEdgeStorageContainerStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeStorageContainerStatus"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeStorageContainerStatus left, DataBoxEdgeStorageContainerStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeStorageContainerStatus"/>. </summary>
        public static implicit operator DataBoxEdgeStorageContainerStatus(string value) => new DataBoxEdgeStorageContainerStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeStorageContainerStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeStorageContainerStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
