// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Azure container mapping of the endpoint. </summary>
    public partial class DataBoxEdgeStorageContainerInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeStorageContainerInfo"/>. </summary>
        /// <param name="storageAccountCredentialId"> ID of the storage account credential used to access storage. </param>
        /// <param name="containerName"> Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob). </param>
        /// <param name="dataFormat"> Storage format used for the file represented by the share. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="storageAccountCredentialId"/> or <paramref name="containerName"/> is null. </exception>
        public DataBoxEdgeStorageContainerInfo(ResourceIdentifier storageAccountCredentialId, string containerName, DataBoxEdgeStorageContainerDataFormat dataFormat)
        {
            Argument.AssertNotNull(storageAccountCredentialId, nameof(storageAccountCredentialId));
            Argument.AssertNotNull(containerName, nameof(containerName));

            StorageAccountCredentialId = storageAccountCredentialId;
            ContainerName = containerName;
            DataFormat = dataFormat;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeStorageContainerInfo"/>. </summary>
        /// <param name="storageAccountCredentialId"> ID of the storage account credential used to access storage. </param>
        /// <param name="containerName"> Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob). </param>
        /// <param name="dataFormat"> Storage format used for the file represented by the share. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxEdgeStorageContainerInfo(ResourceIdentifier storageAccountCredentialId, string containerName, DataBoxEdgeStorageContainerDataFormat dataFormat, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StorageAccountCredentialId = storageAccountCredentialId;
            ContainerName = containerName;
            DataFormat = dataFormat;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeStorageContainerInfo"/> for deserialization. </summary>
        internal DataBoxEdgeStorageContainerInfo()
        {
        }

        /// <summary> ID of the storage account credential used to access storage. </summary>
        public ResourceIdentifier StorageAccountCredentialId { get; set; }
        /// <summary> Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob). </summary>
        public string ContainerName { get; set; }
        /// <summary> Storage format used for the file represented by the share. </summary>
        public DataBoxEdgeStorageContainerDataFormat DataFormat { get; set; }
    }
}
