// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Storage format used for the file represented by the share. </summary>
    public readonly partial struct DataBoxEdgeStorageContainerDataFormat : IEquatable<DataBoxEdgeStorageContainerDataFormat>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeStorageContainerDataFormat"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeStorageContainerDataFormat(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BlockBlobValue = "BlockBlob";
        private const string PageBlobValue = "PageBlob";
        private const string AzureFileValue = "AzureFile";

        /// <summary> BlockBlob. </summary>
        public static DataBoxEdgeStorageContainerDataFormat BlockBlob { get; } = new DataBoxEdgeStorageContainerDataFormat(BlockBlobValue);
        /// <summary> PageBlob. </summary>
        public static DataBoxEdgeStorageContainerDataFormat PageBlob { get; } = new DataBoxEdgeStorageContainerDataFormat(PageBlobValue);
        /// <summary> AzureFile. </summary>
        public static DataBoxEdgeStorageContainerDataFormat AzureFile { get; } = new DataBoxEdgeStorageContainerDataFormat(AzureFileValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeStorageContainerDataFormat"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeStorageContainerDataFormat left, DataBoxEdgeStorageContainerDataFormat right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeStorageContainerDataFormat"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeStorageContainerDataFormat left, DataBoxEdgeStorageContainerDataFormat right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeStorageContainerDataFormat"/>. </summary>
        public static implicit operator DataBoxEdgeStorageContainerDataFormat(string value) => new DataBoxEdgeStorageContainerDataFormat(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeStorageContainerDataFormat other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeStorageContainerDataFormat other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
