// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Type of storage accessed on the storage account. </summary>
    public readonly partial struct DataBoxEdgeStorageAccountType : IEquatable<DataBoxEdgeStorageAccountType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeStorageAccountType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeStorageAccountType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GeneralPurposeStorageValue = "GeneralPurposeStorage";
        private const string BlobStorageValue = "BlobStorage";

        /// <summary> GeneralPurposeStorage. </summary>
        public static DataBoxEdgeStorageAccountType GeneralPurposeStorage { get; } = new DataBoxEdgeStorageAccountType(GeneralPurposeStorageValue);
        /// <summary> BlobStorage. </summary>
        public static DataBoxEdgeStorageAccountType BlobStorage { get; } = new DataBoxEdgeStorageAccountType(BlobStorageValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeStorageAccountType"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeStorageAccountType left, DataBoxEdgeStorageAccountType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeStorageAccountType"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeStorageAccountType left, DataBoxEdgeStorageAccountType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeStorageAccountType"/>. </summary>
        public static implicit operator DataBoxEdgeStorageAccountType(string value) => new DataBoxEdgeStorageAccountType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeStorageAccountType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeStorageAccountType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
