// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Current status of the storage account. </summary>
    public readonly partial struct DataBoxEdgeStorageAccountStatus : IEquatable<DataBoxEdgeStorageAccountStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeStorageAccountStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeStorageAccountStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OKValue = "OK";
        private const string OfflineValue = "Offline";
        private const string UnknownValue = "Unknown";
        private const string UpdatingValue = "Updating";
        private const string NeedsAttentionValue = "NeedsAttention";

        /// <summary> OK. </summary>
        public static DataBoxEdgeStorageAccountStatus OK { get; } = new DataBoxEdgeStorageAccountStatus(OKValue);
        /// <summary> Offline. </summary>
        public static DataBoxEdgeStorageAccountStatus Offline { get; } = new DataBoxEdgeStorageAccountStatus(OfflineValue);
        /// <summary> Unknown. </summary>
        public static DataBoxEdgeStorageAccountStatus Unknown { get; } = new DataBoxEdgeStorageAccountStatus(UnknownValue);
        /// <summary> Updating. </summary>
        public static DataBoxEdgeStorageAccountStatus Updating { get; } = new DataBoxEdgeStorageAccountStatus(UpdatingValue);
        /// <summary> NeedsAttention. </summary>
        public static DataBoxEdgeStorageAccountStatus NeedsAttention { get; } = new DataBoxEdgeStorageAccountStatus(NeedsAttentionValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeStorageAccountStatus"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeStorageAccountStatus left, DataBoxEdgeStorageAccountStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeStorageAccountStatus"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeStorageAccountStatus left, DataBoxEdgeStorageAccountStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeStorageAccountStatus"/>. </summary>
        public static implicit operator DataBoxEdgeStorageAccountStatus(string value) => new DataBoxEdgeStorageAccountStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeStorageAccountStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeStorageAccountStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
