// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Availability of the Sku as preview/stable. </summary>
    public readonly partial struct DataBoxEdgeSkuVersion : IEquatable<DataBoxEdgeSkuVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeSkuVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeSkuVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StableValue = "Stable";
        private const string PreviewValue = "Preview";

        /// <summary> Stable. </summary>
        public static DataBoxEdgeSkuVersion Stable { get; } = new DataBoxEdgeSkuVersion(StableValue);
        /// <summary> Preview. </summary>
        public static DataBoxEdgeSkuVersion Preview { get; } = new DataBoxEdgeSkuVersion(PreviewValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeSkuVersion"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeSkuVersion left, DataBoxEdgeSkuVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeSkuVersion"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeSkuVersion left, DataBoxEdgeSkuVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeSkuVersion"/>. </summary>
        public static implicit operator DataBoxEdgeSkuVersion(string value) => new DataBoxEdgeSkuVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeSkuVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeSkuVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
