// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The location info. </summary>
    public partial class DataBoxEdgeSkuLocationInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeSkuLocationInfo"/>. </summary>
        internal DataBoxEdgeSkuLocationInfo()
        {
            Zones = new ChangeTrackingList<string>();
            Sites = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeSkuLocationInfo"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="zones"> The zones. </param>
        /// <param name="sites"> The sites. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxEdgeSkuLocationInfo(AzureLocation? location, IReadOnlyList<string> zones, IReadOnlyList<string> sites, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Location = location;
            Zones = zones;
            Sites = sites;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The location. </summary>
        public AzureLocation? Location { get; }
        /// <summary> The zones. </summary>
        public IReadOnlyList<string> Zones { get; }
        /// <summary> The sites. </summary>
        public IReadOnlyList<string> Sites { get; }
    }
}
