// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The shipping address of the customer. </summary>
    public partial class DataBoxEdgeShippingAddress
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeShippingAddress"/>. </summary>
        /// <param name="country"> The country name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="country"/> is null. </exception>
        public DataBoxEdgeShippingAddress(string country)
        {
            Argument.AssertNotNull(country, nameof(country));

            Country = country;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeShippingAddress"/>. </summary>
        /// <param name="addressLine1"> The address line1. </param>
        /// <param name="addressLine2"> The address line2. </param>
        /// <param name="addressLine3"> The address line3. </param>
        /// <param name="postalCode"> The postal code. </param>
        /// <param name="city"> The city name. </param>
        /// <param name="state"> The state name. </param>
        /// <param name="country"> The country name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxEdgeShippingAddress(string addressLine1, string addressLine2, string addressLine3, string postalCode, string city, string state, string country, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AddressLine1 = addressLine1;
            AddressLine2 = addressLine2;
            AddressLine3 = addressLine3;
            PostalCode = postalCode;
            City = city;
            State = state;
            Country = country;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeShippingAddress"/> for deserialization. </summary>
        internal DataBoxEdgeShippingAddress()
        {
        }

        /// <summary> The address line1. </summary>
        public string AddressLine1 { get; set; }
        /// <summary> The address line2. </summary>
        public string AddressLine2 { get; set; }
        /// <summary> The address line3. </summary>
        public string AddressLine3 { get; set; }
        /// <summary> The postal code. </summary>
        public string PostalCode { get; set; }
        /// <summary> The city name. </summary>
        public string City { get; set; }
        /// <summary> The state name. </summary>
        public string State { get; set; }
        /// <summary> The country name. </summary>
        public string Country { get; set; }
    }
}
