// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Current monitoring status of the share. </summary>
    public readonly partial struct DataBoxEdgeShareMonitoringStatus : IEquatable<DataBoxEdgeShareMonitoringStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeShareMonitoringStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeShareMonitoringStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static DataBoxEdgeShareMonitoringStatus Enabled { get; } = new DataBoxEdgeShareMonitoringStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static DataBoxEdgeShareMonitoringStatus Disabled { get; } = new DataBoxEdgeShareMonitoringStatus(DisabledValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeShareMonitoringStatus"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeShareMonitoringStatus left, DataBoxEdgeShareMonitoringStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeShareMonitoringStatus"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeShareMonitoringStatus left, DataBoxEdgeShareMonitoringStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeShareMonitoringStatus"/>. </summary>
        public static implicit operator DataBoxEdgeShareMonitoringStatus(string value) => new DataBoxEdgeShareMonitoringStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeShareMonitoringStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeShareMonitoringStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
