// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The DataBoxEdgeRoleType. </summary>
    public readonly partial struct DataBoxEdgeRoleType : IEquatable<DataBoxEdgeRoleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeRoleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeRoleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IoTValue = "IOT";
        private const string AsaValue = "ASA";
        private const string FunctionsValue = "Functions";
        private const string CognitiveValue = "Cognitive";
        private const string MecValue = "MEC";
        private const string CloudEdgeManagementValue = "CloudEdgeManagement";
        private const string KubernetesValue = "Kubernetes";

        /// <summary> IOT. </summary>
        public static DataBoxEdgeRoleType IoT { get; } = new DataBoxEdgeRoleType(IoTValue);
        /// <summary> ASA. </summary>
        public static DataBoxEdgeRoleType Asa { get; } = new DataBoxEdgeRoleType(AsaValue);
        /// <summary> Functions. </summary>
        public static DataBoxEdgeRoleType Functions { get; } = new DataBoxEdgeRoleType(FunctionsValue);
        /// <summary> Cognitive. </summary>
        public static DataBoxEdgeRoleType Cognitive { get; } = new DataBoxEdgeRoleType(CognitiveValue);
        /// <summary> MEC. </summary>
        public static DataBoxEdgeRoleType Mec { get; } = new DataBoxEdgeRoleType(MecValue);
        /// <summary> CloudEdgeManagement. </summary>
        public static DataBoxEdgeRoleType CloudEdgeManagement { get; } = new DataBoxEdgeRoleType(CloudEdgeManagementValue);
        /// <summary> Kubernetes. </summary>
        public static DataBoxEdgeRoleType Kubernetes { get; } = new DataBoxEdgeRoleType(KubernetesValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeRoleType"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeRoleType left, DataBoxEdgeRoleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeRoleType"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeRoleType left, DataBoxEdgeRoleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeRoleType"/>. </summary>
        public static implicit operator DataBoxEdgeRoleType(string value) => new DataBoxEdgeRoleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeRoleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeRoleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
