// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Local Edge Management Status. </summary>
    public readonly partial struct DataBoxEdgeRoleStatus : IEquatable<DataBoxEdgeRoleStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeRoleStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeRoleStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static DataBoxEdgeRoleStatus Enabled { get; } = new DataBoxEdgeRoleStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static DataBoxEdgeRoleStatus Disabled { get; } = new DataBoxEdgeRoleStatus(DisabledValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeRoleStatus"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeRoleStatus left, DataBoxEdgeRoleStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeRoleStatus"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeRoleStatus left, DataBoxEdgeRoleStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeRoleStatus"/>. </summary>
        public static implicit operator DataBoxEdgeRoleStatus(string value) => new DataBoxEdgeRoleStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeRoleStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeRoleStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
