// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Addon Provisioning State. </summary>
    public readonly partial struct DataBoxEdgeRoleAddonProvisioningState : IEquatable<DataBoxEdgeRoleAddonProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeRoleAddonProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeRoleAddonProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string CreatingValue = "Creating";
        private const string CreatedValue = "Created";
        private const string UpdatingValue = "Updating";
        private const string ReconfiguringValue = "Reconfiguring";
        private const string FailedValue = "Failed";
        private const string DeletingValue = "Deleting";

        /// <summary> Invalid. </summary>
        public static DataBoxEdgeRoleAddonProvisioningState Invalid { get; } = new DataBoxEdgeRoleAddonProvisioningState(InvalidValue);
        /// <summary> Creating. </summary>
        public static DataBoxEdgeRoleAddonProvisioningState Creating { get; } = new DataBoxEdgeRoleAddonProvisioningState(CreatingValue);
        /// <summary> Created. </summary>
        public static DataBoxEdgeRoleAddonProvisioningState Created { get; } = new DataBoxEdgeRoleAddonProvisioningState(CreatedValue);
        /// <summary> Updating. </summary>
        public static DataBoxEdgeRoleAddonProvisioningState Updating { get; } = new DataBoxEdgeRoleAddonProvisioningState(UpdatingValue);
        /// <summary> Reconfiguring. </summary>
        public static DataBoxEdgeRoleAddonProvisioningState Reconfiguring { get; } = new DataBoxEdgeRoleAddonProvisioningState(ReconfiguringValue);
        /// <summary> Failed. </summary>
        public static DataBoxEdgeRoleAddonProvisioningState Failed { get; } = new DataBoxEdgeRoleAddonProvisioningState(FailedValue);
        /// <summary> Deleting. </summary>
        public static DataBoxEdgeRoleAddonProvisioningState Deleting { get; } = new DataBoxEdgeRoleAddonProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeRoleAddonProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeRoleAddonProvisioningState left, DataBoxEdgeRoleAddonProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeRoleAddonProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeRoleAddonProvisioningState left, DataBoxEdgeRoleAddonProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeRoleAddonProvisioningState"/>. </summary>
        public static implicit operator DataBoxEdgeRoleAddonProvisioningState(string value) => new DataBoxEdgeRoleAddonProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeRoleAddonProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeRoleAddonProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
