// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Denotes whether move operation is in progress. </summary>
    public readonly partial struct DataBoxEdgeResourceMoveStatus : IEquatable<DataBoxEdgeResourceMoveStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeResourceMoveStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeResourceMoveStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ResourceMoveInProgressValue = "ResourceMoveInProgress";
        private const string ResourceMoveFailedValue = "ResourceMoveFailed";

        /// <summary> None. </summary>
        public static DataBoxEdgeResourceMoveStatus None { get; } = new DataBoxEdgeResourceMoveStatus(NoneValue);
        /// <summary> ResourceMoveInProgress. </summary>
        public static DataBoxEdgeResourceMoveStatus ResourceMoveInProgress { get; } = new DataBoxEdgeResourceMoveStatus(ResourceMoveInProgressValue);
        /// <summary> ResourceMoveFailed. </summary>
        public static DataBoxEdgeResourceMoveStatus ResourceMoveFailed { get; } = new DataBoxEdgeResourceMoveStatus(ResourceMoveFailedValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeResourceMoveStatus"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeResourceMoveStatus left, DataBoxEdgeResourceMoveStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeResourceMoveStatus"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeResourceMoveStatus left, DataBoxEdgeResourceMoveStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeResourceMoveStatus"/>. </summary>
        public static implicit operator DataBoxEdgeResourceMoveStatus(string value) => new DataBoxEdgeResourceMoveStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeResourceMoveStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeResourceMoveStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
