// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Represents a single status change. </summary>
    public partial class DataBoxEdgeOrderStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeOrderStatus"/>. </summary>
        /// <param name="status"> Status of the order as per the allowed status types. </param>
        internal DataBoxEdgeOrderStatus(DataBoxEdgeOrderState status)
        {
            Status = status;
            AdditionalOrderDetails = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeOrderStatus"/>. </summary>
        /// <param name="status"> Status of the order as per the allowed status types. </param>
        /// <param name="updateOn"> Time of status update. </param>
        /// <param name="comments"> Comments related to this status change. </param>
        /// <param name="trackingInformation"> Tracking information related to the state in the ordering flow. </param>
        /// <param name="additionalOrderDetails">
        /// Dictionary to hold generic information which is not stored
        /// by the already existing properties
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxEdgeOrderStatus(DataBoxEdgeOrderState status, DateTimeOffset? updateOn, string comments, DataBoxEdgeTrackingInfo trackingInformation, IReadOnlyDictionary<string, string> additionalOrderDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            UpdateOn = updateOn;
            Comments = comments;
            TrackingInformation = trackingInformation;
            AdditionalOrderDetails = additionalOrderDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeOrderStatus"/> for deserialization. </summary>
        internal DataBoxEdgeOrderStatus()
        {
        }

        /// <summary> Status of the order as per the allowed status types. </summary>
        public DataBoxEdgeOrderState Status { get; }
        /// <summary> Time of status update. </summary>
        public DateTimeOffset? UpdateOn { get; }
        /// <summary> Comments related to this status change. </summary>
        public string Comments { get; }
        /// <summary> Tracking information related to the state in the ordering flow. </summary>
        public DataBoxEdgeTrackingInfo TrackingInformation { get; }
        /// <summary>
        /// Dictionary to hold generic information which is not stored
        /// by the already existing properties
        /// </summary>
        public IReadOnlyDictionary<string, string> AdditionalOrderDetails { get; }
    }
}
