// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Host OS supported by the Arc addon. </summary>
    public readonly partial struct DataBoxEdgeOSPlatformType : IEquatable<DataBoxEdgeOSPlatformType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeOSPlatformType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeOSPlatformType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WindowsValue = "Windows";
        private const string LinuxValue = "Linux";

        /// <summary> Windows. </summary>
        public static DataBoxEdgeOSPlatformType Windows { get; } = new DataBoxEdgeOSPlatformType(WindowsValue);
        /// <summary> Linux. </summary>
        public static DataBoxEdgeOSPlatformType Linux { get; } = new DataBoxEdgeOSPlatformType(LinuxValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeOSPlatformType"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeOSPlatformType left, DataBoxEdgeOSPlatformType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeOSPlatformType"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeOSPlatformType left, DataBoxEdgeOSPlatformType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeOSPlatformType"/>. </summary>
        public static implicit operator DataBoxEdgeOSPlatformType(string value) => new DataBoxEdgeOSPlatformType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeOSPlatformType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeOSPlatformType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
