// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary>
    /// Represents a single node in a Data box Edge/Gateway device
    /// Gateway devices, standalone Edge devices and a single node cluster Edge device will all have 1 node
    /// Multi-node Edge devices will have more than 1 nodes
    /// </summary>
    public partial class DataBoxEdgeNode : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeNode"/>. </summary>
        public DataBoxEdgeNode()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeNode"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="nodeStatus"> The current status of the individual node. </param>
        /// <param name="nodeChassisSerialNumber"> Serial number of the Chassis. </param>
        /// <param name="nodeSerialNumber"> Serial number of the individual node. </param>
        /// <param name="nodeDisplayName"> Display Name of the individual node. </param>
        /// <param name="nodeFriendlySoftwareVersion"> Friendly software version name that is currently installed on the node. </param>
        /// <param name="nodeHcsVersion"> HCS version that is currently installed on the node. </param>
        /// <param name="nodeInstanceId"> Guid instance id of the node. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxEdgeNode(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DataBoxEdgeNodeStatus? nodeStatus, string nodeChassisSerialNumber, string nodeSerialNumber, string nodeDisplayName, string nodeFriendlySoftwareVersion, string nodeHcsVersion, Guid? nodeInstanceId, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            NodeStatus = nodeStatus;
            NodeChassisSerialNumber = nodeChassisSerialNumber;
            NodeSerialNumber = nodeSerialNumber;
            NodeDisplayName = nodeDisplayName;
            NodeFriendlySoftwareVersion = nodeFriendlySoftwareVersion;
            NodeHcsVersion = nodeHcsVersion;
            NodeInstanceId = nodeInstanceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The current status of the individual node. </summary>
        public DataBoxEdgeNodeStatus? NodeStatus { get; }
        /// <summary> Serial number of the Chassis. </summary>
        public string NodeChassisSerialNumber { get; }
        /// <summary> Serial number of the individual node. </summary>
        public string NodeSerialNumber { get; }
        /// <summary> Display Name of the individual node. </summary>
        public string NodeDisplayName { get; }
        /// <summary> Friendly software version name that is currently installed on the node. </summary>
        public string NodeFriendlySoftwareVersion { get; }
        /// <summary> HCS version that is currently installed on the node. </summary>
        public string NodeHcsVersion { get; }
        /// <summary> Guid instance id of the node. </summary>
        public Guid? NodeInstanceId { get; }
    }
}
