// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The network group. </summary>
    public readonly partial struct DataBoxEdgeNetworkGroup : IEquatable<DataBoxEdgeNetworkGroup>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeNetworkGroup"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeNetworkGroup(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string NonRdmaValue = "NonRDMA";
        private const string RdmaValue = "RDMA";

        /// <summary> None. </summary>
        public static DataBoxEdgeNetworkGroup None { get; } = new DataBoxEdgeNetworkGroup(NoneValue);
        /// <summary> NonRDMA. </summary>
        public static DataBoxEdgeNetworkGroup NonRdma { get; } = new DataBoxEdgeNetworkGroup(NonRdmaValue);
        /// <summary> RDMA. </summary>
        public static DataBoxEdgeNetworkGroup Rdma { get; } = new DataBoxEdgeNetworkGroup(RdmaValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeNetworkGroup"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeNetworkGroup left, DataBoxEdgeNetworkGroup right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeNetworkGroup"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeNetworkGroup left, DataBoxEdgeNetworkGroup right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeNetworkGroup"/>. </summary>
        public static implicit operator DataBoxEdgeNetworkGroup(string value) => new DataBoxEdgeNetworkGroup(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeNetworkGroup other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeNetworkGroup other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
