// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Value indicating whether this adapter is valid. </summary>
    public readonly partial struct DataBoxEdgeNetworkAdapterStatus : IEquatable<DataBoxEdgeNetworkAdapterStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeNetworkAdapterStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeNetworkAdapterStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InactiveValue = "Inactive";
        private const string ActiveValue = "Active";

        /// <summary> Inactive. </summary>
        public static DataBoxEdgeNetworkAdapterStatus Inactive { get; } = new DataBoxEdgeNetworkAdapterStatus(InactiveValue);
        /// <summary> Active. </summary>
        public static DataBoxEdgeNetworkAdapterStatus Active { get; } = new DataBoxEdgeNetworkAdapterStatus(ActiveValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeNetworkAdapterStatus"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeNetworkAdapterStatus left, DataBoxEdgeNetworkAdapterStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeNetworkAdapterStatus"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeNetworkAdapterStatus left, DataBoxEdgeNetworkAdapterStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeNetworkAdapterStatus"/>. </summary>
        public static implicit operator DataBoxEdgeNetworkAdapterStatus(string value) => new DataBoxEdgeNetworkAdapterStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeNetworkAdapterStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeNetworkAdapterStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
