// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Value indicating whether this adapter is RDMA capable. </summary>
    public readonly partial struct DataBoxEdgeNetworkAdapterRdmaStatus : IEquatable<DataBoxEdgeNetworkAdapterRdmaStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeNetworkAdapterRdmaStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeNetworkAdapterRdmaStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IncapableValue = "Incapable";
        private const string CapableValue = "Capable";

        /// <summary> Incapable. </summary>
        public static DataBoxEdgeNetworkAdapterRdmaStatus Incapable { get; } = new DataBoxEdgeNetworkAdapterRdmaStatus(IncapableValue);
        /// <summary> Capable. </summary>
        public static DataBoxEdgeNetworkAdapterRdmaStatus Capable { get; } = new DataBoxEdgeNetworkAdapterRdmaStatus(CapableValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeNetworkAdapterRdmaStatus"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeNetworkAdapterRdmaStatus left, DataBoxEdgeNetworkAdapterRdmaStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeNetworkAdapterRdmaStatus"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeNetworkAdapterRdmaStatus left, DataBoxEdgeNetworkAdapterRdmaStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeNetworkAdapterRdmaStatus"/>. </summary>
        public static implicit operator DataBoxEdgeNetworkAdapterRdmaStatus(string value) => new DataBoxEdgeNetworkAdapterRdmaStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeNetworkAdapterRdmaStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeNetworkAdapterRdmaStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
