// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Value indicating whether this adapter has DHCP enabled. </summary>
    public readonly partial struct DataBoxEdgeNetworkAdapterDhcpStatus : IEquatable<DataBoxEdgeNetworkAdapterDhcpStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeNetworkAdapterDhcpStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeNetworkAdapterDhcpStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static DataBoxEdgeNetworkAdapterDhcpStatus Disabled { get; } = new DataBoxEdgeNetworkAdapterDhcpStatus(DisabledValue);
        /// <summary> Enabled. </summary>
        public static DataBoxEdgeNetworkAdapterDhcpStatus Enabled { get; } = new DataBoxEdgeNetworkAdapterDhcpStatus(EnabledValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeNetworkAdapterDhcpStatus"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeNetworkAdapterDhcpStatus left, DataBoxEdgeNetworkAdapterDhcpStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeNetworkAdapterDhcpStatus"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeNetworkAdapterDhcpStatus left, DataBoxEdgeNetworkAdapterDhcpStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeNetworkAdapterDhcpStatus"/>. </summary>
        public static implicit operator DataBoxEdgeNetworkAdapterDhcpStatus(string value) => new DataBoxEdgeNetworkAdapterDhcpStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeNetworkAdapterDhcpStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeNetworkAdapterDhcpStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
