// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    public partial class DataBoxEdgeMountPointMap : IUtf8JsonSerializable, IJsonModel<DataBoxEdgeMountPointMap>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DataBoxEdgeMountPointMap>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DataBoxEdgeMountPointMap>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxEdgeMountPointMap>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataBoxEdgeMountPointMap)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("shareId"u8);
            writer.WriteStringValue(ShareId);
            if (options.Format != "W" && Optional.IsDefined(RoleId))
            {
                writer.WritePropertyName("roleId"u8);
                writer.WriteStringValue(RoleId);
            }
            if (options.Format != "W" && Optional.IsDefined(MountPoint))
            {
                writer.WritePropertyName("mountPoint"u8);
                writer.WriteStringValue(MountPoint);
            }
            if (options.Format != "W" && Optional.IsDefined(MountType))
            {
                writer.WritePropertyName("mountType"u8);
                writer.WriteStringValue(MountType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(RoleType))
            {
                writer.WritePropertyName("roleType"u8);
                writer.WriteStringValue(RoleType.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DataBoxEdgeMountPointMap IJsonModel<DataBoxEdgeMountPointMap>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxEdgeMountPointMap>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataBoxEdgeMountPointMap)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDataBoxEdgeMountPointMap(document.RootElement, options);
        }

        internal static DataBoxEdgeMountPointMap DeserializeDataBoxEdgeMountPointMap(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier shareId = default;
            ResourceIdentifier roleId = default;
            string mountPoint = default;
            DataBoxEdgeMountType? mountType = default;
            DataBoxEdgeRoleType? roleType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("shareId"u8))
                {
                    shareId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("roleId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    roleId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("mountPoint"u8))
                {
                    mountPoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("mountType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mountType = new DataBoxEdgeMountType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("roleType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    roleType = new DataBoxEdgeRoleType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DataBoxEdgeMountPointMap(
                shareId,
                roleId,
                mountPoint,
                mountType,
                roleType,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DataBoxEdgeMountPointMap>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxEdgeMountPointMap>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DataBoxEdgeMountPointMap)} does not support writing '{options.Format}' format.");
            }
        }

        DataBoxEdgeMountPointMap IPersistableModel<DataBoxEdgeMountPointMap>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxEdgeMountPointMap>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDataBoxEdgeMountPointMap(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DataBoxEdgeMountPointMap)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DataBoxEdgeMountPointMap>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
