// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The metric dimension. </summary>
    public partial class DataBoxEdgeMetricDimension
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeMetricDimension"/>. </summary>
        /// <param name="sourceType"> The dimension type. </param>
        /// <param name="sourceName"> The dimension value. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sourceType"/> or <paramref name="sourceName"/> is null. </exception>
        public DataBoxEdgeMetricDimension(string sourceType, string sourceName)
        {
            Argument.AssertNotNull(sourceType, nameof(sourceType));
            Argument.AssertNotNull(sourceName, nameof(sourceName));

            SourceType = sourceType;
            SourceName = sourceName;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeMetricDimension"/>. </summary>
        /// <param name="sourceType"> The dimension type. </param>
        /// <param name="sourceName"> The dimension value. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxEdgeMetricDimension(string sourceType, string sourceName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SourceType = sourceType;
            SourceName = sourceName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeMetricDimension"/> for deserialization. </summary>
        internal DataBoxEdgeMetricDimension()
        {
        }

        /// <summary> The dimension type. </summary>
        public string SourceType { get; set; }
        /// <summary> The dimension value. </summary>
        public string SourceName { get; set; }
    }
}
