// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Metric configuration. </summary>
    public partial class DataBoxEdgeMetricConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeMetricConfiguration"/>. </summary>
        /// <param name="resourceId"> The Resource ID on which the metrics should be pushed. </param>
        /// <param name="counterSets"> Host name for the IoT hub associated to the device. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> or <paramref name="counterSets"/> is null. </exception>
        public DataBoxEdgeMetricConfiguration(ResourceIdentifier resourceId, IEnumerable<DataBoxEdgeMetricCounterSet> counterSets)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));
            Argument.AssertNotNull(counterSets, nameof(counterSets));

            ResourceId = resourceId;
            CounterSets = counterSets.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeMetricConfiguration"/>. </summary>
        /// <param name="resourceId"> The Resource ID on which the metrics should be pushed. </param>
        /// <param name="mdmAccount"> The MDM account to which the counters should be pushed. </param>
        /// <param name="metricNameSpace"> The MDM namespace to which the counters should be pushed. This is required if MDMAccount is specified. </param>
        /// <param name="counterSets"> Host name for the IoT hub associated to the device. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxEdgeMetricConfiguration(ResourceIdentifier resourceId, string mdmAccount, string metricNameSpace, IList<DataBoxEdgeMetricCounterSet> counterSets, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceId = resourceId;
            MdmAccount = mdmAccount;
            MetricNameSpace = metricNameSpace;
            CounterSets = counterSets;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeMetricConfiguration"/> for deserialization. </summary>
        internal DataBoxEdgeMetricConfiguration()
        {
        }

        /// <summary> The Resource ID on which the metrics should be pushed. </summary>
        public ResourceIdentifier ResourceId { get; set; }
        /// <summary> The MDM account to which the counters should be pushed. </summary>
        public string MdmAccount { get; set; }
        /// <summary> The MDM namespace to which the counters should be pushed. This is required if MDMAccount is specified. </summary>
        public string MetricNameSpace { get; set; }
        /// <summary> Host name for the IoT hub associated to the device. </summary>
        public IList<DataBoxEdgeMetricCounterSet> CounterSets { get; }
    }
}
