// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The type of the job. </summary>
    public readonly partial struct DataBoxEdgeJobType : IEquatable<DataBoxEdgeJobType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeJobType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeJobType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string ScanForUpdatesValue = "ScanForUpdates";
        private const string DownloadUpdatesValue = "DownloadUpdates";
        private const string InstallUpdatesValue = "InstallUpdates";
        private const string RefreshShareValue = "RefreshShare";
        private const string RefreshContainerValue = "RefreshContainer";
        private const string BackupValue = "Backup";
        private const string RestoreValue = "Restore";
        private const string TriggerSupportPackageValue = "TriggerSupportPackage";

        /// <summary> Invalid. </summary>
        public static DataBoxEdgeJobType Invalid { get; } = new DataBoxEdgeJobType(InvalidValue);
        /// <summary> ScanForUpdates. </summary>
        public static DataBoxEdgeJobType ScanForUpdates { get; } = new DataBoxEdgeJobType(ScanForUpdatesValue);
        /// <summary> DownloadUpdates. </summary>
        public static DataBoxEdgeJobType DownloadUpdates { get; } = new DataBoxEdgeJobType(DownloadUpdatesValue);
        /// <summary> InstallUpdates. </summary>
        public static DataBoxEdgeJobType InstallUpdates { get; } = new DataBoxEdgeJobType(InstallUpdatesValue);
        /// <summary> RefreshShare. </summary>
        public static DataBoxEdgeJobType RefreshShare { get; } = new DataBoxEdgeJobType(RefreshShareValue);
        /// <summary> RefreshContainer. </summary>
        public static DataBoxEdgeJobType RefreshContainer { get; } = new DataBoxEdgeJobType(RefreshContainerValue);
        /// <summary> Backup. </summary>
        public static DataBoxEdgeJobType Backup { get; } = new DataBoxEdgeJobType(BackupValue);
        /// <summary> Restore. </summary>
        public static DataBoxEdgeJobType Restore { get; } = new DataBoxEdgeJobType(RestoreValue);
        /// <summary> TriggerSupportPackage. </summary>
        public static DataBoxEdgeJobType TriggerSupportPackage { get; } = new DataBoxEdgeJobType(TriggerSupportPackageValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeJobType"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeJobType left, DataBoxEdgeJobType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeJobType"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeJobType left, DataBoxEdgeJobType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeJobType"/>. </summary>
        public static implicit operator DataBoxEdgeJobType(string value) => new DataBoxEdgeJobType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeJobType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeJobType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
