// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The current status of the job. </summary>
    public readonly partial struct DataBoxEdgeJobStatus : IEquatable<DataBoxEdgeJobStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeJobStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeJobStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string RunningValue = "Running";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string PausedValue = "Paused";
        private const string ScheduledValue = "Scheduled";

        /// <summary> Invalid. </summary>
        public static DataBoxEdgeJobStatus Invalid { get; } = new DataBoxEdgeJobStatus(InvalidValue);
        /// <summary> Running. </summary>
        public static DataBoxEdgeJobStatus Running { get; } = new DataBoxEdgeJobStatus(RunningValue);
        /// <summary> Succeeded. </summary>
        public static DataBoxEdgeJobStatus Succeeded { get; } = new DataBoxEdgeJobStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static DataBoxEdgeJobStatus Failed { get; } = new DataBoxEdgeJobStatus(FailedValue);
        /// <summary> Canceled. </summary>
        public static DataBoxEdgeJobStatus Canceled { get; } = new DataBoxEdgeJobStatus(CanceledValue);
        /// <summary> Paused. </summary>
        public static DataBoxEdgeJobStatus Paused { get; } = new DataBoxEdgeJobStatus(PausedValue);
        /// <summary> Scheduled. </summary>
        public static DataBoxEdgeJobStatus Scheduled { get; } = new DataBoxEdgeJobStatus(ScheduledValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeJobStatus"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeJobStatus left, DataBoxEdgeJobStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeJobStatus"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeJobStatus left, DataBoxEdgeJobStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeJobStatus"/>. </summary>
        public static implicit operator DataBoxEdgeJobStatus(string value) => new DataBoxEdgeJobStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeJobStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeJobStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
