// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Details related to the IPv4 address configuration. </summary>
    public partial class DataBoxEdgeIPv4Config
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeIPv4Config"/>. </summary>
        internal DataBoxEdgeIPv4Config()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeIPv4Config"/>. </summary>
        /// <param name="ipAddress"> The IPv4 address of the network adapter. </param>
        /// <param name="subnet"> The IPv4 subnet of the network adapter. </param>
        /// <param name="gateway"> The IPv4 gateway of the network adapter. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxEdgeIPv4Config(IPAddress ipAddress, string subnet, string gateway, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IPAddress = ipAddress;
            Subnet = subnet;
            Gateway = gateway;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The IPv4 address of the network adapter. </summary>
        public IPAddress IPAddress { get; }
        /// <summary> The IPv4 subnet of the network adapter. </summary>
        public string Subnet { get; }
        /// <summary> The IPv4 gateway of the network adapter. </summary>
        public string Gateway { get; }
    }
}
