// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The download phase. </summary>
    public readonly partial struct DataBoxEdgeDownloadPhase : IEquatable<DataBoxEdgeDownloadPhase>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeDownloadPhase"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeDownloadPhase(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string InitializingValue = "Initializing";
        private const string DownloadingValue = "Downloading";
        private const string VerifyingValue = "Verifying";

        /// <summary> Unknown. </summary>
        public static DataBoxEdgeDownloadPhase Unknown { get; } = new DataBoxEdgeDownloadPhase(UnknownValue);
        /// <summary> Initializing. </summary>
        public static DataBoxEdgeDownloadPhase Initializing { get; } = new DataBoxEdgeDownloadPhase(InitializingValue);
        /// <summary> Downloading. </summary>
        public static DataBoxEdgeDownloadPhase Downloading { get; } = new DataBoxEdgeDownloadPhase(DownloadingValue);
        /// <summary> Verifying. </summary>
        public static DataBoxEdgeDownloadPhase Verifying { get; } = new DataBoxEdgeDownloadPhase(VerifyingValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeDownloadPhase"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeDownloadPhase left, DataBoxEdgeDownloadPhase right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeDownloadPhase"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeDownloadPhase left, DataBoxEdgeDownloadPhase right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeDownloadPhase"/>. </summary>
        public static implicit operator DataBoxEdgeDownloadPhase(string value) => new DataBoxEdgeDownloadPhase(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeDownloadPhase other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeDownloadPhase other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
