// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The type of the Data Box Edge/Gateway device. </summary>
    public readonly partial struct DataBoxEdgeDeviceType : IEquatable<DataBoxEdgeDeviceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeDeviceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeDeviceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DataBoxEdgeDeviceValue = "DataBoxEdgeDevice";

        /// <summary> DataBoxEdgeDevice. </summary>
        public static DataBoxEdgeDeviceType DataBoxEdgeDevice { get; } = new DataBoxEdgeDeviceType(DataBoxEdgeDeviceValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeDeviceType"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeDeviceType left, DataBoxEdgeDeviceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeDeviceType"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeDeviceType left, DataBoxEdgeDeviceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeDeviceType"/>. </summary>
        public static implicit operator DataBoxEdgeDeviceType(string value) => new DataBoxEdgeDeviceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeDeviceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeDeviceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
