// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The status of the Data Box Edge/Gateway device. </summary>
    public readonly partial struct DataBoxEdgeDeviceStatus : IEquatable<DataBoxEdgeDeviceStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeDeviceStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeDeviceStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadyToSetupValue = "ReadyToSetup";
        private const string OnlineValue = "Online";
        private const string OfflineValue = "Offline";
        private const string NeedsAttentionValue = "NeedsAttention";
        private const string DisconnectedValue = "Disconnected";
        private const string PartiallyDisconnectedValue = "PartiallyDisconnected";
        private const string MaintenanceValue = "Maintenance";

        /// <summary> ReadyToSetup. </summary>
        public static DataBoxEdgeDeviceStatus ReadyToSetup { get; } = new DataBoxEdgeDeviceStatus(ReadyToSetupValue);
        /// <summary> Online. </summary>
        public static DataBoxEdgeDeviceStatus Online { get; } = new DataBoxEdgeDeviceStatus(OnlineValue);
        /// <summary> Offline. </summary>
        public static DataBoxEdgeDeviceStatus Offline { get; } = new DataBoxEdgeDeviceStatus(OfflineValue);
        /// <summary> NeedsAttention. </summary>
        public static DataBoxEdgeDeviceStatus NeedsAttention { get; } = new DataBoxEdgeDeviceStatus(NeedsAttentionValue);
        /// <summary> Disconnected. </summary>
        public static DataBoxEdgeDeviceStatus Disconnected { get; } = new DataBoxEdgeDeviceStatus(DisconnectedValue);
        /// <summary> PartiallyDisconnected. </summary>
        public static DataBoxEdgeDeviceStatus PartiallyDisconnected { get; } = new DataBoxEdgeDeviceStatus(PartiallyDisconnectedValue);
        /// <summary> Maintenance. </summary>
        public static DataBoxEdgeDeviceStatus Maintenance { get; } = new DataBoxEdgeDeviceStatus(MaintenanceValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeDeviceStatus"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeDeviceStatus left, DataBoxEdgeDeviceStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeDeviceStatus"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeDeviceStatus left, DataBoxEdgeDeviceStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeDeviceStatus"/>. </summary>
        public static implicit operator DataBoxEdgeDeviceStatus(string value) => new DataBoxEdgeDeviceStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeDeviceStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeDeviceStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
