// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The kind of the device. </summary>
    public readonly partial struct DataBoxEdgeDeviceKind : IEquatable<DataBoxEdgeDeviceKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeDeviceKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeDeviceKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureDataBoxGatewayValue = "AzureDataBoxGateway";
        private const string AzureStackEdgeValue = "AzureStackEdge";
        private const string AzureStackHubValue = "AzureStackHub";
        private const string AzureModularDataCentreValue = "AzureModularDataCentre";

        /// <summary> AzureDataBoxGateway. </summary>
        public static DataBoxEdgeDeviceKind AzureDataBoxGateway { get; } = new DataBoxEdgeDeviceKind(AzureDataBoxGatewayValue);
        /// <summary> AzureStackEdge. </summary>
        public static DataBoxEdgeDeviceKind AzureStackEdge { get; } = new DataBoxEdgeDeviceKind(AzureStackEdgeValue);
        /// <summary> AzureStackHub. </summary>
        public static DataBoxEdgeDeviceKind AzureStackHub { get; } = new DataBoxEdgeDeviceKind(AzureStackHubValue);
        /// <summary> AzureModularDataCentre. </summary>
        public static DataBoxEdgeDeviceKind AzureModularDataCentre { get; } = new DataBoxEdgeDeviceKind(AzureModularDataCentreValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeDeviceKind"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeDeviceKind left, DataBoxEdgeDeviceKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeDeviceKind"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeDeviceKind left, DataBoxEdgeDeviceKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeDeviceKind"/>. </summary>
        public static implicit operator DataBoxEdgeDeviceKind(string value) => new DataBoxEdgeDeviceKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeDeviceKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeDeviceKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
