// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> DataResidencyType enum. </summary>
    public readonly partial struct DataBoxEdgeDataResidencyType : IEquatable<DataBoxEdgeDataResidencyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeDataResidencyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeDataResidencyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GeoZoneReplicationValue = "GeoZoneReplication";
        private const string ZoneReplicationValue = "ZoneReplication";

        /// <summary> GeoZoneReplication. </summary>
        public static DataBoxEdgeDataResidencyType GeoZoneReplication { get; } = new DataBoxEdgeDataResidencyType(GeoZoneReplicationValue);
        /// <summary> ZoneReplication. </summary>
        public static DataBoxEdgeDataResidencyType ZoneReplication { get; } = new DataBoxEdgeDataResidencyType(ZoneReplicationValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeDataResidencyType"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeDataResidencyType left, DataBoxEdgeDataResidencyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeDataResidencyType"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeDataResidencyType left, DataBoxEdgeDataResidencyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeDataResidencyType"/>. </summary>
        public static implicit operator DataBoxEdgeDataResidencyType(string value) => new DataBoxEdgeDataResidencyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeDataResidencyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeDataResidencyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
