// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Data policy of the share. </summary>
    public readonly partial struct DataBoxEdgeDataPolicy : IEquatable<DataBoxEdgeDataPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeDataPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxEdgeDataPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CloudValue = "Cloud";
        private const string LocalValue = "Local";

        /// <summary> Cloud. </summary>
        public static DataBoxEdgeDataPolicy Cloud { get; } = new DataBoxEdgeDataPolicy(CloudValue);
        /// <summary> Local. </summary>
        public static DataBoxEdgeDataPolicy Local { get; } = new DataBoxEdgeDataPolicy(LocalValue);
        /// <summary> Determines if two <see cref="DataBoxEdgeDataPolicy"/> values are the same. </summary>
        public static bool operator ==(DataBoxEdgeDataPolicy left, DataBoxEdgeDataPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxEdgeDataPolicy"/> values are not the same. </summary>
        public static bool operator !=(DataBoxEdgeDataPolicy left, DataBoxEdgeDataPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxEdgeDataPolicy"/>. </summary>
        public static implicit operator DataBoxEdgeDataPolicy(string value) => new DataBoxEdgeDataPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxEdgeDataPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxEdgeDataPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
