// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Represent the secrets intended for encryption with asymmetric key pair. </summary>
    public partial class AsymmetricEncryptedSecret
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AsymmetricEncryptedSecret"/>. </summary>
        /// <param name="value"> The value of the secret. </param>
        /// <param name="encryptionAlgorithm"> The algorithm used to encrypt "Value". </param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AsymmetricEncryptedSecret(string value, DataBoxEdgeEncryptionAlgorithm encryptionAlgorithm)
        {
            Argument.AssertNotNull(value, nameof(value));

            Value = value;
            EncryptionAlgorithm = encryptionAlgorithm;
        }

        /// <summary> Initializes a new instance of <see cref="AsymmetricEncryptedSecret"/>. </summary>
        /// <param name="value"> The value of the secret. </param>
        /// <param name="encryptionCertThumbprint"> Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null. </param>
        /// <param name="encryptionAlgorithm"> The algorithm used to encrypt "Value". </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AsymmetricEncryptedSecret(string value, string encryptionCertThumbprint, DataBoxEdgeEncryptionAlgorithm encryptionAlgorithm, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            EncryptionCertThumbprint = encryptionCertThumbprint;
            EncryptionAlgorithm = encryptionAlgorithm;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AsymmetricEncryptedSecret"/> for deserialization. </summary>
        internal AsymmetricEncryptedSecret()
        {
        }

        /// <summary> The value of the secret. </summary>
        public string Value { get; set; }
        /// <summary> Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null. </summary>
        public string EncryptionCertThumbprint { get; set; }
        /// <summary> The algorithm used to encrypt "Value". </summary>
        public DataBoxEdgeEncryptionAlgorithm EncryptionAlgorithm { get; set; }
    }
}
