// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    public partial class AsymmetricEncryptedSecret : IUtf8JsonSerializable, IJsonModel<AsymmetricEncryptedSecret>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AsymmetricEncryptedSecret>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AsymmetricEncryptedSecret>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AsymmetricEncryptedSecret>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AsymmetricEncryptedSecret)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("value"u8);
            writer.WriteStringValue(Value);
            if (Optional.IsDefined(EncryptionCertThumbprint))
            {
                writer.WritePropertyName("encryptionCertThumbprint"u8);
                writer.WriteStringValue(EncryptionCertThumbprint);
            }
            writer.WritePropertyName("encryptionAlgorithm"u8);
            writer.WriteStringValue(EncryptionAlgorithm.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AsymmetricEncryptedSecret IJsonModel<AsymmetricEncryptedSecret>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AsymmetricEncryptedSecret>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AsymmetricEncryptedSecret)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAsymmetricEncryptedSecret(document.RootElement, options);
        }

        internal static AsymmetricEncryptedSecret DeserializeAsymmetricEncryptedSecret(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string value = default;
            string encryptionCertThumbprint = default;
            DataBoxEdgeEncryptionAlgorithm encryptionAlgorithm = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    value = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("encryptionCertThumbprint"u8))
                {
                    encryptionCertThumbprint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("encryptionAlgorithm"u8))
                {
                    encryptionAlgorithm = new DataBoxEdgeEncryptionAlgorithm(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AsymmetricEncryptedSecret(value, encryptionCertThumbprint, encryptionAlgorithm, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AsymmetricEncryptedSecret>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AsymmetricEncryptedSecret>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AsymmetricEncryptedSecret)} does not support writing '{options.Format}' format.");
            }
        }

        AsymmetricEncryptedSecret IPersistableModel<AsymmetricEncryptedSecret>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AsymmetricEncryptedSecret>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAsymmetricEncryptedSecret(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AsymmetricEncryptedSecret)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AsymmetricEncryptedSecret>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
